const { contextBridge, ipcRenderer } = require('electron');

contextBridge.exposeInMainWorld('electronAPI', {
    send: (channel, data) => {
        const validChannels = [
            'show-settings', 'close-settings-window', 'set-store-data', 
            'toggle-slide-main', 'save-image-to-disk', 'set-window-interactivity',
            'open-external-link'
        ];
        if (validChannels.includes(channel)) {
            ipcRenderer.send(channel, data);
        }
    },
    invoke: (channel) => {
        const validChannels = ['get-store-data', 'open-file-dialog'];
        if (validChannels.includes(channel)) {
            return ipcRenderer.invoke(channel);
        }
    },
    on: (channel, callback) => {
        const validChannels = ['store-updated', 'toggle-slide'];
        if (validChannels.includes(channel)) {
            const subscription = (event, ...args) => callback(...args);
            ipcRenderer.on(channel, subscription);
            return () => ipcRenderer.removeListener(channel, subscription);
        }
    }
});